DROP DATABASE clase_one;

CREATE DATABASE clase_one;

\c clase_one


CREATE TABLE libro (id SERIAL PRIMARY KEY,
                    titulo varchar(255),
                    autor  varchar(50)
                  );


CREATE TABLE edicion (id_libro integer,
                    descripcion varchar(255),
                    anho  integer,
                    CONSTRAINT edicion_pk PRIMARY KEY(id_libro,descripcion)
                  );

CREATE TABLE copia (id_libro integer,
                    desc_edicion varchar(255),
                    id_copia  integer,
                    cantidad_impresiones  integer,
                    CONSTRAINT copia_pk PRIMARY KEY(id_libro,desc_edicion,id_copia)
                  );

CREATE TABLE cliente (dni SERIAL PRIMARY KEY,
                    nombre varchar(255),
                    fecnac date
                    );


CREATE TABLE cliente_compra_copia (documento integer,
                                  id_libro integer,
                                  desc_edicion varchar(255),
                                  id_copia  integer,
                                  fecha_compra timestamp DEFAULT current_timestamp,
                    CONSTRAINT cliente_compra_copia_pk PRIMARY KEY(documento, id_libro,desc_edicion,id_copia)
                  );


/* CONSTRAINT edicion_libro_fk FOREIGN KEY (id_libro)
REFERENCES libro (id)
ON UPDATE NO ACTION ON DELETE NO ACTION */


ALTER TABLE edicion ADD
CONSTRAINT edicion_libro_fk FOREIGN KEY (id_libro)
REFERENCES libro (id)
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE copia ADD
CONSTRAINT copia_edicion_fk FOREIGN KEY (id_libro,desc_edicion)
REFERENCES edicion (id_libro,descripcion)
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE cliente_compra_copia ADD
CONSTRAINT compra_copia_fk FOREIGN KEY (id_libro,desc_edicion,id_copia)
REFERENCES copia (id_libro,desc_edicion,id_copia)
ON UPDATE NO ACTION ON DELETE NO ACTION;

ALTER TABLE cliente_compra_copia ADD
CONSTRAINT compra_cliente_fk FOREIGN KEY (documento)
REFERENCES cliente (dni)
ON UPDATE NO ACTION ON DELETE NO ACTION;
