CREATE TABLE LIBRO
	(ISBN INT PRIMARY KEY,
     Titulo VARCHAR(32))
;
	
INSERT INTO LIBRO
	(ISBN, Titulo)
VALUES
	(33058621, 'Inferno'),
	(35494238, 'Cien Anios de Soledad'),
	(58764384, 'Venas abiertas de America Latina'),
	(38784929, 'Aeropuerto')
;

CREATE TABLE EJEMPLAR
	(CodEjemplar INT PRIMARY KEY,
     ISBNLibro INT,
     Edicion INT,
     CONSTRAINT fk_ejemplar FOREIGN KEY (ISBNLibro)
     REFERENCES LIBRO(ISBN)
     )
;
	
INSERT INTO EJEMPLAR
	(CodEjemplar, ISBNLibro, Edicion)
VALUES
	(503, 33058621, 2),
	(785, 33058621, 4),
	(065, 35494238, 1),
	(098, 38784929, 3),
	(223, 58764384, 3),
	(101, 58764384, 1)
;

CREATE TABLE NACIONALIDAD
	(NombrePais VARCHAR(9) PRIMARY KEY,
     nacionalidad VARCHAR(9)
    )
;
	
INSERT INTO NACIONALIDAD
	(NombrePais, nacionalidad)
VALUES
	('Argentina', 'Argentina'),
	('Brasil', 'Brasilera'),
	('Peru', 'Peruana'),
	('Mexico', 'Mexicana')
;

CREATE TABLE SOCIO
	(CodSocio INT PRIMARY KEY,
     NombreyApellido VARCHAR(17),
     FechaIngreso datetime, 
     MontoCuota INT,
     Matricula INT,
     Pais VARCHAR(9),
     CONSTRAINT fk_nombrepais FOREIGN KEY(Pais) REFERENCES NACIONALIDAD(NombrePais))
;
	
INSERT INTO SOCIO
	(CodSocio, NombreyApellido, FechaIngreso, MontoCuota, Matricula, Pais)
VALUES
	(78, 'Sheldon Cooper', '2011-05-03 00:00:00', 12, 4, 'Brasil'),
	(54, 'Howard Wolowitz', '2011-01-21 00:00:00', 16, 0, 'Argentina'),
	(03, 'Amy Farrah Fowler', '2011-02-17 00:00:00', 5, 10, 'Argentina')
;

CREATE TABLE PRESTAMO
	(CodEjemplar INT,
     CodSocio INT,
     FechaPrestamo datetime,
     FechaDevolucion VARCHAR(10),
     PRIMARY KEY(CodEjemplar,CodSocio),
     CONSTRAINT fk_CodEjemplar FOREIGN KEY (CodEjemplar)
         REFERENCES EJEMPLAR(CodEjemplar),
     CONSTRAINT fk_CodSocio FOREIGN KEY (CodSocio)
         REFERENCES SOCIO(CodSocio)
    )
;
	
INSERT INTO PRESTAMO
	(CodEjemplar, CodSocio, FechaPrestamo, FechaDevolucion)
VALUES
	(503, 78, '2012-05-03 00:00:00', '2012/05/08'),
	(223, 54, '2013-01-21 00:00:00', '2013/03/01'),
	(785, 78, '2013-02-20 00:00:00', NULL),
	(101, 03, '2013-11-17 00:00:00', '2013/11/18')
;

